package com.bycom.versapro.MenuTypes.RSS.Serializables;


import android.view.View;

import org.jsoup.Jsoup;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RSSItem implements Serializable {


    private String title = "";
    private String link = "";
    private String description = "";

    private String thumbnailUrl = "";

    private String date = "";

    private String content = "";

    private String author = "";

    private String views = "";


    private int type;


    private View adView;


    public View getAdView() {
        return adView;
    }

    public String getViews() {
        return views;
    }

    public int getType() {
        return type;
    }

    public String getDate() {
        return date;
    }

    public String getAuthor() {
        return author;
    }

    public String getContent() {
        return content;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public String getLink() {
        return link;
    }

    public String getDescription() {
        return description;
    }

    public String getTitle() {
        return title;
    }


    public void setAdView(View adView) {
        this.adView = adView;
    }

    public void setViews(String views) {

        try {
            long viewCount = Long.parseLong(views);
            DecimalFormat df = new DecimalFormat("#,##0.#", DecimalFormatSymbols.getInstance(Locale.US));

            if (viewCount >= 1_000_000_000) {
                this.views = df.format(viewCount / 1_000_000_000.0) + "B";
            } else if (viewCount >= 1_000_000) {
                this.views = df.format(viewCount / 1_000_000.0) + "M";
            } else if (viewCount >= 1_000) {
                this.views = df.format(viewCount / 1_000.0) + "K";
            } else {
                this.views = df.format(viewCount);
            }
        } catch (NumberFormatException e) {
            this.views = "";
        }
    }

    public void setType(int TYPE) {
        this.type = TYPE;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setContent(String content) {
        this.content = Jsoup.parse(content).html();
    }

    public void setDate(String date) {
        try {
            String[] datePatterns = {
                    "EEE, MMM dd yyyy HH:mm:ss a",    // Format 1: "Fri, Jan 17 2025 06:20:49 PM"
                    "yyyy-MM-dd'T'HH:mm:ssZ",         // Format 2: "2012-02-20T00:43:50+00:00"
                    "EEE, dd MMM yyyy HH:mm:ss Z",    // Format 3: "Tue, 14 Jan 2025 18:07:51 +0000"
                    "yyyy-MM-dd'T'HH:mm:ss.SSSZ"      // Format 4: "2016-05-10T16:34:00.003+05:30"
            };

            Date parsedDate = null;
            for (String pattern : datePatterns) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
                    parsedDate = sdf.parse(date);
                    break;
                } catch (Exception ignored) {}
            }


            SimpleDateFormat outputFormat = new SimpleDateFormat("d MMM yyyy • hh:mm a", Locale.US);
            outputFormat.setTimeZone(TimeZone.getDefault());
            this.date = outputFormat.format(parsedDate);

        } catch (Exception e) {
            this.date = date;
        }
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setDescription(String description) {
        this.description = Jsoup.parse(description).html();
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
